
const stockShowNavDefaultList = [
    {
        name: '涨跌',
        Ename: 'upDown',
        color: 'newpColor'
    },
    {
        name: '涨跌幅',
        Ename: 'upDownRatio',
        color: 'newpColor'
    },
    {
        name: '最新价',
        Ename: 'lastPrice',
        color: 'newpColor'
    },
    {
        name: '昨收',
        Ename: 'preClosePrice',
        color: 'pingColor'
    },
    {
        name: '今开',
        Ename: 'openPrice',
        color: 'openColor'
    },
    {
        name: '最高',
        Ename: 'highestPrice',
        color: 'highColor'
    },
    {
        name: '最低',
        Ename: 'lowestPrice',
        color: 'lowColor'
    },
    {
        name: '涨停',
        Ename: 'upperLimitPrice',
        color: 'upperlimitColor'
    },
    {
        name: '跌停',
        Ename: 'lowerLimitPrice',
        color: 'lowerlimitColor'
    },
    {
        name: '成交量',
        Ename: 'volume',
        color: 'pingColor'
    },
    {
        name: '成交金额',
        Ename: 'turnover',
        color: 'pingColor'
    },
    {
        name: '买一价',
        Ename: 'bidPrice1',
        color: 'buyColor'
    },
    {
        name: '卖一价',
        Ename: 'askPrice1',
        color: 'saleColor'
    },
    {
        name: '买一量',
        Ename: 'BidVolume1',
        color: 'pingColor'
    },
    {
        name: '卖一量',
        Ename: 'AskVolume1',
        color: 'pingColor'
    }
]
const futureShowNavDefaultList = [
    {
        name: '涨跌',
        Ename: 'upDown',
        color: 'newpColor'
    },
    {
        name: '涨跌幅',
        Ename: 'upDownRatio',
        color: 'newpColor'
    },
    {
        name: '最新价',
        Ename: 'lastPrice',
        color: 'newpColor'
    },
    {
        name: '昨收',
        Ename: 'preClosePrice',
        color: 'pingColor'
    },
    {
        name: '今开',
        Ename: 'openPrice',
        color: 'openColor'
    },
    {
        name: '最高',
        Ename: 'highestPrice',
        color: 'highColor'
    },
    {
        name: '最低',
        Ename: 'lowestPrice',
        color: 'lowColor'
    },
    {
        name: '昨结算',
        Ename: 'preSettlementPrice',
        color: 'pingColor'
    },
    {
        name: '涨停',
        Ename: 'upperLimitPrice',
        color: 'upperlimitColor'
    },
    {
        name: '跌停',
        Ename: 'lowerLimitPrice',
        color: 'lowerlimitColor'
    },
    {
        name: '成交量',
        Ename: 'volume',
        color: 'pingColor'
    },
    {
        name: '成交金额',
        Ename: 'turnover',
        color: 'pingColor'
    },
    {
        name: '买一价',
        Ename: 'bidPrice1',
        color: 'buyColor'
    },
    {
        name: '卖一价',
        Ename: 'askPrice1',
        color: 'saleColor'
    },
    {
        name: '买一量',
        Ename: 'BidVolume1',
        color: 'pingColor'
    },
    {
        name: '卖一量',
        Ename: 'AskVolume1',
        color: 'pingColor'
    }
]
const optionShowNavDefaultList = [
    {
        name: '涨跌',
        Ename: 'upDown',
        color: 'newpColor'
    },
    {
        name: '涨跌幅',
        Ename: 'upDownRatio',
        color: 'newpColor'
    },
    {
        name: '最新价',
        Ename: 'lastPrice',
        color: 'newpColor'
    },
    {
        name: '昨收',
        Ename: 'preClosePrice',
        color: 'pingColor'
    },
    {
        name: '今开',
        Ename: 'openPrice',
        color: 'openColor'
    },
    {
        name: '持仓量',
        Ename: 'openInterest',
        color: 'openColor'
    },
    {
        name: '最高',
        Ename: 'highestPrice',
        color: 'highColor'
    },
    {
        name: '最低',
        Ename: 'lowestPrice',
        color: 'lowColor'
    },
    {
        name: '成交量',
        Ename: 'volume',
        color: 'pingColor'
    },
    {
        name: '成交金额',
        Ename: 'turnover',
        color: 'pingColor'
    },
    {
        name: '剩余',
        Ename: 'expireDate',
        color: 'pingColor'
    },
    {
        name: '行权价',
        Ename: 'strikePrice',
        color: 'pingColor'
    },
    {
        name: '买一价',
        Ename: 'bidPrice1',
        color: 'buyColor'
    },
    {
        name: '卖一价',
        Ename: 'askPrice1',
        color: 'saleColor'
    },
    {
        name: '买一量',
        Ename: 'BidVolume1',
        color: 'pingColor'
    },
    {
        name: '卖一量',
        Ename: 'AskVolume1',
        color: 'pingColor'
    }
]

const stockNoShowNavDefaultList = [
    {
        name: '修改时间',
        Ename: 'UpdateTime',
        color: 'pingColor'
    },
    {
        name: '买二价',
        Ename: 'bidPrice2',
        color: 'buyColor'
    },
    {
        name: '卖二价',
        Ename: 'askPrice2',
        color: 'saleColor'
    },
    {
        name: '买二量',
        Ename: 'BidVolume2',
        color: 'pingColor'
    },
    {
        name: '卖二量',
        Ename: 'AskVolume2',
        color: 'pingColor'
    },
    {
        name: '买三价',
        Ename: 'bidPrice3',
        color: 'buyColor'
    },
    {
        name: '卖三价',
        Ename: 'askPrice3',
        color: 'saleColor'
    },
    {
        name: '买三量',
        Ename: 'BidVolume3',
        color: 'pingColor'
    },
    {
        name: '卖三量',
        Ename: 'AskVolume3',
        color: 'pingColor'
    },
    {
        name: '买四价',
        Ename: 'bidPrice4',
        color: 'buyColor'
    },
    {
        name: '卖四价',
        Ename: 'askPrice4',
        color: 'saleColor'
    },
    {
        name: '买四量',
        Ename: 'BidVolume4',
        color: 'pingColor'
    },
    {
        name: '卖四量',
        Ename: 'AskVolume4',
        color: 'pingColor'
    },
    {
        name: '买五价',
        Ename: 'bidPrice5',
        color: 'buyColor'
    },
    {
        name: '卖五价',
        Ename: 'askPrice5',
        color: 'saleColor'
    },
    {
        name: '买五量',
        Ename: 'BidVolume5',
        color: 'pingColor'
    },
    {
        name: '卖五量',
        Ename: 'AskVolume5',
        color: 'pingColor'
    },
    {
        name: '当日笔数',
        Ename: 'TradingCount',
        color: 'pingColor'
    }
]
let stockAllNavList = JSON.parse(JSON.stringify([...stockShowNavDefaultList, ...stockNoShowNavDefaultList])) 
let futureAllNavList = [...futureShowNavDefaultList, ...stockNoShowNavDefaultList]
let optionAllNavList = [...optionShowNavDefaultList, ...stockNoShowNavDefaultList]
let stockShowNavList
let stockNoShowNavList

let futureShowNavList
let futureNoShowNavList
let optionShowNavList
let optionNoShowNavList

//股票列表localStorage
const stock_list_name = 'stockListName1'
const future_list_name = 'futureListName1'
const option_list_name = 'optionListName1'
//股票列表
function setStockNavStorage(content) {
    if (typeof content !== 'string') {
        content = JSON.stringify(content)
      }
      window.localStorage.setItem(stock_list_name, content)
}
function getStockNavStorage() {
    return JSON.parse(window.localStorage.getItem(stock_list_name))
}

//期货列表
function setFutureNavStorage(content) {
    if (typeof content !== 'string') {
        content = JSON.stringify(content)
      }
      window.localStorage.setItem(future_list_name, content)
}
function getFutureNavStorage() {
    return JSON.parse(window.localStorage.getItem(future_list_name))
}

//期权列表
function setOptionNavStorage(content) {
    if (typeof content !== 'string') {
        content = JSON.stringify(content)
      }
      window.localStorage.setItem(option_list_name, content)
}
function getOptionNavStorage() {
    return JSON.parse(window.localStorage.getItem(option_list_name))
}

function setStockShowNavList() {
    let stockStorage = getStockNavStorage()
    if(stockStorage === null) {
        stockShowNavList = JSON.parse(JSON.stringify(stockShowNavDefaultList))
        stockNoShowNavList = JSON.parse(JSON.stringify(stockNoShowNavDefaultList))
        setStockNavStorage(JSON.stringify(stockShowNavDefaultList))
    } else {
        stockShowNavList = [...stockStorage]
        stockNoShowNavList = stockAllNavList.filter(item => {
            return stockShowNavList.every(item1 => {
                return item.Ename != item1.Ename;
            })
        })
    }
}

function setFutureShowNavList() {
    let stockStorage = getFutureNavStorage()
    if(stockStorage === null) {
        futureShowNavList = [...futureShowNavDefaultList]
        futureNoShowNavList = [...stockNoShowNavDefaultList]
        setFutureNavStorage(JSON.stringify(futureShowNavDefaultList))
    } else {
        futureShowNavList = [...stockStorage]
        futureNoShowNavList = futureAllNavList.filter(item => {
            return futureShowNavList.every(item1 => {
                return item.Ename != item1.Ename;
            })
        })
    }
}

function setOptionShowNavList() {
    let stockStorage = getOptionNavStorage()
    if(stockStorage === null) {
        optionShowNavList = [...optionShowNavDefaultList]
        optionNoShowNavList = [...stockNoShowNavDefaultList]
        setOptionNavStorage(JSON.stringify(optionShowNavDefaultList))
    } else {
        optionShowNavList = [...stockStorage]
        optionNoShowNavList = optionAllNavList.filter(item => {
            return optionShowNavList.every(item1 => {
                return item.Ename != item1.Ename;
            })
        })
    }
}

setStockShowNavList()
setFutureShowNavList()
setOptionShowNavList()

//恢复默认
function NavRestoreDefault() {
    if(Page_Module == 'stocklist') {
        stockShowNavList = [...stockShowNavDefaultList]
        stockNoShowNavList = [...stockNoShowNavDefaultList]
        setStockNavStorage(JSON.stringify(stockShowNavList))
        $('.sys-shownav-content').removeClass('active')
        $('.tableNav_right').css('minWidth','1570px')
        $('.infinite-list-content').css('minWidth','1570px')
        Make_stockListNav(stockShowNavList)
        let stockList = T_stockSltList[showStockType].slice(stock_startNum, stock_endNum)
        Make_stock(stockList) 
    } else if(Page_Module == 'futurelist') {
        futureShowNavList = [...futureShowNavDefaultList]
        futureNoShowNavList = [...stockNoShowNavDefaultList]
        setFutureNavStorage(JSON.stringify(futureShowNavList))
        $('.sys-shownav-content').removeClass('active')
        $('.FtableNav_right').css('minWidth','1570px')
        $('.Finfinite-list-content').css('minWidth','1570px')
        Make_stockListNav(futureShowNavList)
        let futureList = T_futureList[showFutureType].slice(stock_startNum, stock_endNum)
        Make_future(futureList)
    } else if(Page_Module == 'optionlist'){
        optionShowNavList = [...optionShowNavDefaultList]
        optionNoShowNavList = [...stockNoShowNavDefaultList]
        setOptionNavStorage(JSON.stringify(optionShowNavList))
        $('.sys-shownav-content').removeClass('active')
        $('.OtableNav_right').css('minWidth','1820px')
        $('.Oinfinite-list-content').css('minWidth','1820px')
        Make_stockListNav(optionShowNavList)
        let futureList = T_futureOptionList[showFutureOptionType].slice(stock_startNum, stock_endNum)
        Make_futureOption(futureList)
    }
    
}



function Make_stockListNav(navList) {
    let html = ''
    if(Page_Module == 'stocklist' || Page_Module == 'goldlist' || Page_Module== 'plateHtml' || Page_Module == "EtfConHtml" || Page_Module == "RankConHtml") {
        for(let i=0;i<navList.length;i++) {
            html+='<div class="tableNav-itemBtn pointer" onclick="changeSort(\''+navList[i].Ename+'\',\''+(i+3)+'\')">'+navList[i].name+'</div>'
        }
    } else if(Page_Module == 'futurelist') {
        for(let i=0;i<navList.length;i++) {
            html+='<div class="tableNav-itemBtn pointer" onclick="changeFutureSort(\''+navList[i].Ename+'\',\''+(i+2)+'\')">'+navList[i].name+'</div>'
        }
    } else if(Page_Module == 'optionlist') {
        for(let i=0;i<navList.length;i++) {
            html+='<div class="tableNav-itemBtn pointer" onclick="changeOptionSort(\''+navList[i].Ename+'\',\''+(i+3)+'\')">'+navList[i].name+'</div>'
        }
    }
    
    $('#tableNav_right').html(html)
}


function toggleShowNavBar() {
    var evt = window.event;
    var _x = evt.clientX - 54;
    var clientWidth = document.documentElement.clientWidth || document.body.clientWidth;
    var scrollLeft = document.documentElement.scrollLeft || document.body.scrollLeft;

    
    $("#sysCodeListNavMenu").css("left", `${_x}px`)

    if (_x + 80 > clientWidth + scrollLeft) {
        var top2 = (_x - 80);
        $("#sysCodeListNavMenu").css("left", `${top2}px`)
    } else if(_x < 80) {
        var top2 = (_x + 80);
        $("#sysCodeListNavMenu").css("left", `${top2}px`)
    }
    $('#sysCodeListNavMenu').addClass('active')
}

function sysCodeShowNavMenu() {
    $('#sysCodeListNavMenu').removeClass('active')
    $('.sys-shownav-content').addClass('active')
    let html = ''
    let nhtml = ''
    if(Page_Module == 'stocklist') {
        for(let i=0;i<stockShowNavList.length;i++) {
            html+='<div class="shownav-table-item" ondblclick="deleteShowNavItem(\''+stockShowNavList[i].name+'\',this)">'+stockShowNavList[i].name+'</div>'
        }
        for(let i=0;i<stockNoShowNavList.length;i++) {
            nhtml+='<div class="shownav-table-item" ondblclick="deleteShowNavItem(\''+stockNoShowNavList[i].name+'\',this)">'+stockNoShowNavList[i].name+'</div>'
        }
    } else if(Page_Module == 'futurelist') {
        for(let i=0;i<futureShowNavList.length;i++) {
            html+='<div class="shownav-table-item" ondblclick="deleteShowNavItem(\''+futureShowNavList[i].name+'\',this)">'+futureShowNavList[i].name+'</div>'
        }
        for(let i=0;i<futureNoShowNavList.length;i++) {
            nhtml+='<div class="shownav-table-item" ondblclick="deleteShowNavItem(\''+futureNoShowNavList[i].name+'\',this)">'+futureNoShowNavList[i].name+'</div>'
        }
    } else if(Page_Module == 'optionlist') {
        for(let i=0;i<optionShowNavList.length;i++) {
            html+='<div class="shownav-table-item" ondblclick="deleteShowNavItem(\''+optionShowNavList[i].name+'\',this)">'+optionShowNavList[i].name+'</div>'
        }
        for(let i=0;i<optionNoShowNavList.length;i++) {
            nhtml+='<div class="shownav-table-item" ondblclick="deleteShowNavItem(\''+optionNoShowNavList[i].name+'\',this)">'+optionNoShowNavList[i].name+'</div>'
        }
    }
    $('#showNavTableList').html(html)
    $('#noShowNavTableList').html(nhtml)
}



function shownavSureBtn(){
    let showlist = document.getElementById('showNavTableList').childNodes
    let noshowlist = document.getElementById('noShowNavTableList').childNodes
    let showTextList = Array.from(showlist).map(item => item.innerHTML)
    let noShowTextList = Array.from(noshowlist).map(item => item.innerHTML)
    let showLen = showTextList.length
    let noShowLen = noShowTextList.length
    
    if(Page_Module == 'stocklist') {
        let showAllNavList = JSON.parse(JSON.stringify(stockAllNavList))
        let noShowAllNavList = JSON.parse(JSON.stringify(stockAllNavList))
        let showNavList = showAllNavList.sort(function(a,b) {
            return showTextList.indexOf(a['name']) - showTextList.indexOf(b['name']) 
        })
        let noShowNavlist = noShowAllNavList.sort(function(a,b) {
            return noShowTextList.indexOf(a['name']) - noShowTextList.indexOf(b['name']) 
        })
        stockShowNavList = showNavList.slice(noShowLen)
        stockNoShowNavList = noShowNavlist.slice(showLen)
        setStockNavStorage(JSON.stringify(stockShowNavList))
        $('.sys-shownav-content').removeClass('active')
        $('.tableNav_right').css('minWidth',(showLen * 90 + 220)+'px')
        $('.infinite-list-content').css('minWidth',(showLen * 90 + 220)+'px')
        Make_stockListNav(stockShowNavList)
        let stockList = T_stockSltList[showStockType].slice(stock_startNum, stock_endNum)
        Make_stock(stockList)
    } else if(Page_Module == 'futurelist') {
        let showAllNavList = JSON.parse(JSON.stringify(futureAllNavList))
        let noShowAllNavList = JSON.parse(JSON.stringify(futureAllNavList))
        let showNavList = showAllNavList.sort(function(a,b) {
            return showTextList.indexOf(a['name']) - showTextList.indexOf(b['name']) 
        })
        let noShowNavlist = noShowAllNavList.sort(function(a,b) {
            return noShowTextList.indexOf(a['name']) - noShowTextList.indexOf(b['name']) 
        })
        futureShowNavList = showNavList.slice(noShowLen)
        futureNoShowNavList = noShowNavlist.slice(showLen)
        setFutureNavStorage(JSON.stringify(futureShowNavList))
        $('.sys-shownav-content').removeClass('active')
        $('.FtableNav_right').css('minWidth',(showLen * 90 + 130)+'px')
        $('.Finfinite-list-content').css('minWidth',(showLen * 90 + 130)+'px')
        Make_stockListNav(futureShowNavList)
        let futureList = T_futureList[showFutureType].slice(stock_startNum, stock_endNum)
        Make_future(futureList)
    } else if(Page_Module == 'optionlist') {
        let showAllNavList = JSON.parse(JSON.stringify(optionAllNavList))
        let noShowAllNavList = JSON.parse(JSON.stringify(optionAllNavList))
        let showNavList = showAllNavList.sort(function(a,b) {
            return showTextList.indexOf(a['name']) - showTextList.indexOf(b['name']) 
        })
        let noShowNavlist = noShowAllNavList.sort(function(a,b) {
            return noShowTextList.indexOf(a['name']) - noShowTextList.indexOf(b['name']) 
        })
        optionShowNavList = showNavList.slice(noShowLen)
        optionNoShowNavList = noShowNavlist.slice(showLen)
        setOptionNavStorage(JSON.stringify(optionShowNavList))
        $('.sys-shownav-content').removeClass('active')
        $('.OtableNav_right').css('minWidth',(showLen * 90 + 340)+'px')
        $('.Oinfinite-list-content').css('minWidth',(showLen * 90 + 340)+'px')
        Make_stockListNav(optionShowNavList)
        let futureList = T_futureOptionList[showFutureOptionType].slice(stock_startNum, stock_endNum)
        Make_futureOption(futureList)
    }
    
}

function sysShowNavColse() {
    $('.sys-shownav-content').removeClass('active')
}
function deleteShowNavItem(name,obj) {
    let list = document.getElementById('showNavTableList').childNodes
    let textlist = []
    list.forEach(item => {
        textlist.push(item.innerHTML)
    })
    let box = document.getElementById('showNavTableList')
    let noBox = document.getElementById('noShowNavTableList')
    if(textlist.indexOf(name) > -1) {
        box.removeChild(obj)
        noBox.appendChild(obj)
    } else {
        noBox.removeChild(obj)
        box.appendChild(obj)
    }
}
