function initOvewOption(g_Mdata) {
    let para_lastprice = Number(g_Mdata.newPrice);
    let para_LXPrice = Number(g_Mdata.LXprice)
    let para_prePrice = Number(g_Mdata.yestclose);
    let sSep = ''
    var titleColor
    if (Math.abs(para_lastprice - para_prePrice) < g_doubleMin) {
        sSep = '--';
        titleColor = g_marketZeroColor;
    }else if (para_lastprice - para_prePrice > g_doubleMin) {
        sSep = '\u25B2'
        titleColor = g_upColor;
    }else if (para_lastprice - para_prePrice < g_doubleMinNegative) {
        sSep = '\u25BC';
        titleColor = g_downColor;
    }
    var upWill = Number(para_lastprice - para_prePrice).toFixed(2)
    var upFlaot = ((upWill / para_prePrice.toFixed(2)) * 100).toFixed(2) + '%'
    var indexTitle = Number(para_lastprice).toFixed(2) + ' ' + upWill + ' ' + sSep + ' ' + upFlaot 
    let lxTitle = ' 领先 ' + para_LXPrice
    return {
        title: [{    //标题
            text: g_Mdata.title,
            left: '10px',
            top: '0px',
            textStyle: {
                color: '#DDDDDD',
                fontSize: 12
            },
        },{
            text: indexTitle,
            left: '70px',
            top: '0px',
            textStyle: {
                color: titleColor,
                fontSize: 12,
                fontWeight: "normal"
            },
        },{
            text: lxTitle,
            left: '230px',
            top: '0px',
            textStyle: {
                color: '#ffab42',
                fontSize: 12,
                fontWeight: "normal"
            },
        }],
        grid: [
            {
                id: 'gd1',
                left: '60px',
                right: '60px',
                height: (g_ovewChartHeight - 60) * 0.73,
                top: '30px',
            },
            {
                id: 'gd2',
                left: '60px',
                right: '60px',
                height: (g_ovewChartHeight - 60) * 0.73,//'67.5%', //主K线的高度,
                top: '30px',
            },
            {
                id: 'gd3',
                left: '60px',
                right: '60px',
                top: (g_ovewChartHeight - 60) * 0.73 + 30,//'74.5%',
                height: (g_ovewChartHeight - 60) * 0.27, //'22%', //交易量图的高度
                bottom: '10px',
            }
        ],
        xAxis: [ //==== x轴
            { //主图 
                //type: 'time',
                gridIndex: 0,
                data: g_Mdata.times,
                axisLabel: { //label文字设置
                    show: false
                },
                splitLine: {
                    show: false,
                },
                axisTick: {
                    show: false
                },
                //splitNumber: 2,
            },
            {   //主图右侧
                show: false,
                gridIndex: 1,
                data: g_Mdata.times,
                axisLabel: { //label文字设置
                    show: false
                },
                splitLine: {
                    show: false,
                }
            },
            { //交易量图
                //splitNumber: 2,
                type: 'category',
                gridIndex: 2,
                data: g_Mdata.times,
                axisLabel: { //label文字设置
                    textStyle: {
                        color: "#c7c7c7",
                        fontSize: 12,
                    },
                    //color: function (value, index) {
                    //    return "#c7c7c7";
                    //},
                    interval: 59,
                    fontSize: 12,

                },
            },
        ],
        yAxis: [ //y轴
            {
                gridIndex: 0,
                //scale: true,
                axisLabel: { //label文字设置 
                    inside: false, //label文字朝内对齐 
                    //fontWeight: 'bold',
                    color: function (val) {
                        if (Math.abs(val - g_Mdata.yestclose) < g_doubleMin) {
                            return '#aaaaaa';
                        }
                        return val > g_Mdata.yestclose ? g_upColor : g_downColor;
                    },
                    formatter: function (val, index) {
                        //if (index === 0)    //第一个不显示 免得和成交量label重叠
                        //    return;
                        return Number(val).toFixed(g_Mdata.priceDecimal);
                    },
                    showMinLabel: false,
                },
                z: 4,
                splitLine: { //分割线设置
                    show: true,
                    lineStyle: {
                        color: '#646464',
                        opacity: 0.3,
                    }
                },


                splitNumber: 7,
                max: g_Mdata.priceMax,
                min: g_Mdata.priceMin,
                interval: ((g_Mdata.priceMax - g_Mdata.priceMin) / 6),
                //max: g_MMax,
                //min: g_MMin,
            },
            {
                scale: true,
                gridIndex: 1,
                position: 'right',
                z: 4,
                axisLabel: { //label文字设置
                    color: function (val) {
                        if (Math.abs(val - g_Mdata.yestclose) < g_doubleMin) {
                            return '#aaaaaa';
                        }
                        return val > g_Mdata.yestclose ? g_upColor : g_downColor;
                    },
                    inside: false, //label文字朝内对齐 
                    //fontWeight: 'bold',
                    formatter: function (val) {
                        return ratioCalculate3(val, g_Mdata.yestclose) + '%';
                    },
                    showMinLabel: false,
                },
                splitLine: { //分割线设置
                    show: false,
                    lineStyle: {
                        color: '#181a23'
                    }
                },

                splitNumber: 7,
                max: g_Mdata.priceMax,
                min: g_Mdata.priceMin,
                interval: ((g_Mdata.priceMax - g_Mdata.priceMin) / 6),
            },
            { //交易量图
                gridIndex: 2,
                position: 'left',
                z: 4,
                axisLine: {
                    onZero: false
                },
                axisTick: {
                    show: false
                },
                splitLine: { //分割线设置
                    show: true,
                    lineStyle: {
                        color: '#646464',
                        opacity: 0.3,
                    }
                },
                axisLabel: { //label文字设置
                    color: '#c7c7c7',
                    inside: false,
                    formatter: function (value, index) {
                        return ProduceVolume4(value, g_Mdata.productId, 0);
                    },
                    //fontSize: 8
                },

                splitNumber: 3,
                max: g_Mdata.volumeMax,
                min: 0,
                interval: ((g_Mdata.volumeMax) / 2),
            },
            { //交易量图右侧
                gridIndex: 2,
                position: 'right',
                z: 4,
                //splitNumber: 3,
                axisLine: {
                    onZero: false
                },
                axisTick: {
                    show: false
                },
                splitLine: {
                    show: false
                },
                axisLabel: { //label文字设置
                    color: '#c7c7c7',
                    inside: false,
                    formatter: function (value, index) {
                        return ProduceVolume4(value, g_Mdata.productId, 0);
                    },
                    //fontSize: 8
                },

                splitNumber: 3,
                max: g_Mdata.volumeMax,
                min: 0,
                interval: ((g_Mdata.volumeMax) / 2),
            }
        ],
        dataZoom: [
        ],
        animation: false,//禁止动画效果
        backgroundColor: g_bgColor,
        blendMode: 'source-over',
        series: [
            {
                name: '当前价',
                type: 'line',
                data: g_Mdata.priceArr,
                smooth: true,
                areaStyle: {
                    normal: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                            offset: 0,
                            color: 'rgba(0, 136, 212, 0.7)'
                        }, {
                            offset: 0.8,
                            color: 'rgba(0, 136, 212, 0.02)'
                        }], false),
                        shadowColor: 'rgba(0, 0, 0, 0.1)',
                        shadowBlur: 10
                    }
                },
                symbol: "circle", //中时有小圆点 
                symbolSize: 2,
                showSymbol: false,
                lineStyle: {
                    normal: {
                        opacity: 1,
                        color: '#39afe6',
                        width: 1
                    }
                },

                markLine:
                {
                    symbol: 'none',
                    label:
                    {
                        //color: "#fff"
                        show: false,
                    },
                    lineStyle:
                    {
                        type: "solid",
                        color: '#646464',
                        opacity: 0.3,
                    },
                    data: g_Mdata.g_M_XLabels,
                },
            },

            {
                name: '领先',
                type: 'line',
                data: g_Mdata.LXpriceArr,
                smooth: true,
                symbol: "none",
                gridIndex: 1,
                xAxisIndex: 1,
                yAxisIndex: 1,
                lineStyle: { //标线的样式
                    normal: {
                        opacity: 0.8,
                        color: '#ffab42',
                        width: 1
                    }
                },

            },
            {
                name: '成交量',
                type: 'bar',
                gridIndex: 2,
                xAxisIndex: 2,
                yAxisIndex: 2,
                data: g_Mdata.vol,
                barWidth: '60%',
                itemStyle: {
                    normal: {
                        color: function (params) {
                            var colorList;
                            var compareVar = (params.dataIndex <= 0) ? g_Mdata.yestclose : g_Mdata.priceArr[params.dataIndex - 1];

                            if (g_Mdata.priceArr[params.dataIndex] >= compareVar) {
                                colorList = g_upColor;
                            } else {
                                colorList = g_downColor;
                            }
                            return colorList;
                        },
                    }
                },
                markLine:
                {
                    symbol: 'none',
                    label:
                    {
                        show: false,
                    },
                    lineStyle:
                    {
                        type: "solid",
                        color: '#646464',
                        opacity: 0.3,
                    },
                    data: g_Mdata.g_M_XLabels,
                }
            }
        ]
    };
}

let g_ovewMainType = 'overview'
let ovew_insturmentIDIndex = 0
function changeOvewType(num,obj) {
    $(obj).addClass('active').siblings().removeClass('active')
    if(num == 0){
        $('#ZhOverContent').html(overViewTem)
        ovew_insturmentIDIndex = 0
        g_ovewMainType = 'overview'
        window_external.Page_CQCReq('16','')  //大盘龙头
        window_external.Page_CQCReq('27','')
        window_external.Page_CQCReq('31','')
        for(var i=0;i<ovew_insturmentIDArray.length;i++){
            // window_external.Page_CQCReq('41',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","indexCode":ovew_insturmentIDArray[0]}))
            window_external.Page_CQCReq('39',ovew_insturmentIDArray[i])
        }
        window_external.Page_CQCReq('41',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","indexCode":ovew_insturmentIDArray[0]}))
        window_external.Page_ModuleChange('stocklist','')
        InitOvewPage()
        makeOvewAllMsg()
        makePlateUperThree(zhplate_insturmentUpArray,1)
        makePlateUperThree(zhplate_insturmentDownArray,2)
        makeOvewFirstThree(ovewFirstThree)
    } else if(num == 1) {
        $('#ZhOverContent').html('')
        $('#ZhOverContent').html(zhplateTem)
        g_ovewMainType = 'zhplate'
        zhplateChangeType(0)
    } else if(num == 2) {
        $('#ZhOverContent').html('')
        $('#ZhOverContent').html(zhplateTem)
        g_ovewMainType = 'zhplate1'
        zhplateChangeType(0)
    }
    

}
const toggleShowChild = function( element,num) {
    $(element).addClass('active').parent('.ovew-menu-item').siblings().find('.ovew-menu-itemtitle').removeClass('active')
    $('.ovew-menu-item').eq(num).find('.ovew-menu-itemsp').toggleClass('active')
}
const ovewChangeShowCon = function(element,index) {
    if(element.checked) {
        $('.over-content-item').eq(index).addClass('active')
    } else {
        $('.over-content-item').eq(index).removeClass('active')
    }
}

const resetInput = () => {
    let checkInputAll = document.getElementsByName('checkbox')
    for(let i=0;i<checkInputAll.length;i++) {
        if(checkInputAll[i].checked) {
            $('.over-content-item').eq(i).addClass('active')
        }
    }
}

$(function() {
    resetInput()
    
})


//大盘页面指数行情
let ovew_chartsFirstShow = true
let g_ovewChart0;
let g_ovewChart1;
let g_ovewChart2;

let g_ovewChartHeight
let g_ovewmarketPrePrice = 1.0;
let g_ovewmarketFirstShow0 = true
let g_ovewmarketFirstShow1 = true
let g_ovewmarketFirstShow2 = true
let g_haveovewHistory = new Array()
let g_ovew_data = new Array() 
// let g_ovewpriceDecimal = 0
let g_ovewTradingDay
let ovew_todayData = false
let ovew_timeLength = 0;
// let g_ovewTitle0 = ''
// let g_ovewTitleColor0
// let g_ovewTitle1 = ''
// let g_ovewTitleColor1
// let g_ovewTitle2 = ''
// let g_ovewTitleColor2
let ovew_insturmentNameArray = ['上证指数', '深证成指', '创业板指']
let ovew_insturmentIDArray = ['000001.SH', '399001.SZ', '399006.SZ']
// let ovew_yestCloseArray = [3072.83, 10077.96, 2015.36]

let ovew_TimeFrame = '09:30$11:30$13:00$15:00'

function InitOvewPage() {
    g_ovew_data = new Array()
    g_ovewmarketFirstShow0 = true
    g_ovewmarketFirstShow1 = true
    g_ovewmarketFirstShow2 = true
    g_haveovewHistory = new Array()
    // ovew_chartsFirstShow = true
    resetInput()
    for (let i = 0; i < 3; i++) {
        let ssdata = generate_ovewtimeframe(ovew_TimeFrame, i)
        g_ovew_data.push(ssdata)
    }
    g_ovewChart0 = echarts.init(document.getElementById('m_ovewmian0'));
    g_ovewChart1 = echarts.init(document.getElementById('m_ovewmian1'));
    g_ovewChart2 = echarts.init(document.getElementById('m_ovewmian2'));
    g_ovewChartHeight = g_ovewChart1.getHeight();
    // if (ovew_chartsFirstShow == false) {
        g_ovewChart0.setOption(initOvewOption(g_ovew_data[0]));
        g_ovewChart1.setOption(initOvewOption(g_ovew_data[1]));
        g_ovewChart2.setOption(initOvewOption(g_ovew_data[2]));
    // }
    ovew_chartsFirstShow = false
}

function ovewChartResize() {

    g_ovewChartHeight = g_ovewChart1.getHeight();
    g_ovewChart0.resize()
    g_ovewChart1.resize()
    g_ovewChart2.resize()
    g_ovewChart0.setOption(initOvewOption(g_ovew_data[0]));
    g_ovewChart1.setOption(initOvewOption(g_ovew_data[1]));
    g_ovewChart2.setOption(initOvewOption(g_ovew_data[2]));
}


function generate_ovewtimeframe(timestr, index) {
    let priceArr = new Array();
    let LXpriceArr = new Array()
    let vol = new Array();
    let nvolume = new Array();
    let times = time_arr(timestr);
    if (index == 0) {
        Index_timeLength = times.length
    }
    let g_M_XLabels = generate_x_label(timestr);
    let code = ovew_insturmentIDArray[index]
    let title = ovew_insturmentNameArray[index]
    let productId = ReProductId(code)
    let priceDecimal = RePriceDecimal(productId)
    let yestclose = ReMarketPrePrice(code)
    return {
        newPrice: 1,
        LXPrice:1,
        priceArr: priceArr,
        LXpriceArr,
        vol: vol,
        times: times,
        g_M_XLabels: g_M_XLabels,
        productId: productId,
        yestclose,
        priceDecimal,
        title,
        priceMax: 2.0,
        priceMin: 1.0,
        bMaxMin: 0,
        volumeMax: 1,
        volumeMin: 0,
        nvolume: nvolume
    }
}

//找不到返回-1,找到返回下标0开始
function CheckTimes_OvewM(para_time) {
    for (let i = 0; i < g_ovew_data[0].times.length; i++) {
        if (g_ovew_data[0].times[i] == para_time)
            return i;
    }
    return -1;
}

function CheckId_Ovew(id) {
    for (var i = 0; i < ovew_insturmentIDArray.length; i++) {
        if (ovew_insturmentIDArray[i] == id)
            return i;
    }
    return -1;
}

function OvewhaveHistory(id) {
    for (var i = 0; i < g_haveovewHistory.length; i++) {
        if (g_haveovewHistory[i] == id)
            return true;
    }
    return false;
}

function SetOvewMaxMin(price, volume, index) {
    price = parseFloat(price)
    if (g_ovew_data[index].bMaxMin == 0) {
        g_ovew_data[index].priceMax = price;
        g_ovew_data[index].priceMin = price;
        g_ovew_data[index].bMaxMin = 1;
    }

    if (g_ovew_data[index].priceMax < price) {
        g_ovew_data[index].priceMax = price;
    }
    if (g_ovew_data[index].priceMin > price) {
        g_ovew_data[index].priceMin = price;
    }
    volume = parseInt(volume);
    if (g_ovew_data[index].volumeMax < volume) {
        g_ovew_data[index].volumeMax = volume;
    }
    if (g_ovew_data[index].volumeMin > volume) {
        g_ovew_data[index].volumeMin = volume;
    }
}


function BalanceOvewMaxMin(index) {


    if (g_ovew_data[index].priceMax < g_ovew_data[index].yestclose)
        g_ovew_data[index].priceMax = g_ovew_data[index].yestclose;
    if (g_ovew_data[index].priceMin > g_ovew_data[index].yestclose)
        g_ovew_data[index].priceMin = g_ovew_data[index].yestclose;

    if ((g_ovew_data[index].priceMax >= g_ovew_data[index].yestclose) && (g_ovew_data[index].priceMax < g_ovew_data[index].yestclose * 1.01))
        g_ovew_data[index].priceMax = g_ovew_data[index].yestclose * 1.01;
    if ((g_ovew_data[index].priceMin <= g_ovew_data[index].yestclose) && (g_ovew_data[index].priceMin > g_ovew_data[index].yestclose * 0.99))
        g_ovew_data[index].priceMin = g_ovew_data[index].yestclose * 0.99;

    let absValue = (Math.abs(g_ovew_data[index].priceMax - g_ovew_data[index].yestclose) > Math.abs(g_ovew_data[index].priceMin - g_ovew_data[index].yestclose)) ?
        Math.abs(g_ovew_data[index].priceMax - g_ovew_data[index].yestclose) : Math.abs(g_ovew_data[index].priceMin - g_ovew_data[index].yestclose);

    g_ovew_data[index].priceMax = g_ovew_data[index].yestclose + absValue;
    g_ovew_data[index].priceMin = g_ovew_data[index].yestclose - absValue;

}

// 集合竞价期间左侧分时图需要初始化 并设置昨收盘(昨结算)
function OvewM_FirstShow(para_prePrice, index) {
    para_prePrice = parseFloat(para_prePrice);

    if (index == 0) {
        if (g_ovewmarketFirstShow0 == true) {
            g_ovewmarketFirstShow0 = false
            g_ovew_data[0].yestclose = para_prePrice;
            g_ovew_data[0].newPrice = para_prePrice;
            SetOvewMaxMin(para_prePrice, 0, index);
            BalanceOvewMaxMin(index);
            g_ovewChart0.setOption(initOvewOption(g_ovew_data[0]));
        }
    } else if (index == 1) {
        if (g_ovewmarketFirstShow1 == true) {
            g_ovewmarketFirstShow1 = false
            g_ovew_data[1].yestclose = para_prePrice;
            g_ovew_data[1].newPrice = para_prePrice;
            SetOvewMaxMin(para_prePrice, 0, index);
            BalanceOvewMaxMin(index);
            g_ovewChart1.setOption(initOvewOption(g_ovew_data[1]));
        }
    } else if (index == 2) {
        if (g_ovewmarketFirstShow2 == true) {
            g_ovewmarketFirstShow2 = false
            g_ovew_data[2].yestclose = para_prePrice;
            g_ovew_data[2].newPrice = para_prePrice;
            SetOvewMaxMin(para_prePrice, 0, index);
            BalanceOvewMaxMin(index);
            g_ovewChart2.setOption(initOvewOption(g_ovew_data[2]));
        }
    } 

}
function Trigger_OvewPrePrice(para_prePrice, index) {
    g_ovewmarketPrePrice = para_prePrice;
    OvewM_FirstShow(g_ovewmarketPrePrice, index);
}


function Trigger_Movew_History(sysCode, times, price, LXprice, volume, volumeChange, size, prePrice) {
    let productId = ReProductId(sysCode)
    let priceDecimal = RePriceDecimal(productId)
    let exchangeID = ReExchangeId(sysCode)
    g_ovewTradingDay = ReTradingDay(exchangeID)
    g_haveovewHistory.push(sysCode)

    let index = CheckId_Ovew(sysCode)

    if (size == 0) {
        return
    }

    OvewM_FirstShow(prePrice, index);
    let aPrice = price.split(',');
    let aLXprice = LXprice.split(',')
    let volumeArr = volume.split(',');
    let aVolume = volumeChange.split(',');

    for (var i = 0; i < size; i++) {
        g_ovew_data[index].priceArr[i] = parseFloat(aPrice[i]).toFixed(priceDecimal);
        g_ovew_data[index].LXpriceArr[i] = parseFloat(aLXprice[i]).toFixed(priceDecimal);
        g_ovew_data[index].vol[i] = aVolume[i];
        g_ovew_data[index].nvolume[i] = volumeArr[i]
        SetOvewMaxMin(parseFloat(aPrice[i]).toFixed(priceDecimal), parseInt(aVolume[i]), index);
        SetOvewMaxMin(parseFloat(aLXprice[i]).toFixed(priceDecimal), parseInt(aVolume[i]), index);
    }
    BalanceOvewMaxMin(index);
    g_ovew_data[index].newPrice = parseFloat(aPrice[Number(size) - 1]).toFixed(2)
    g_ovew_data[index].LXprice = parseFloat(aLXprice[Number(size) - 1]).toFixed(2)
    if (index == 0) {
        g_ovewChart0.setOption(initOvewOption(g_ovew_data[0]));
    } else if (index == 1) {
        g_ovewChart1.setOption(initOvewOption(g_ovew_data[1]));
    } else if(index == 2) {
        g_ovewChart2.setOption(initOvewOption(g_ovew_data[2]));
    } 
}

// 即时数据
function Trigger_Movew_Now(b_id, b_time, b_price, b_LXprice, b_volume,TradingDay) {
    let productId =ReProductId(b_id)
    let priceDecimal = RePriceDecimal(productId)
    var j = CheckTimes_OvewM(b_time.substring(0, 5)); //返回下标
    if (j == -1) {
        return;
    }
    let index = CheckId_Ovew(b_id)
    if(index == -1) {
        return
    }
    let priceLength = g_ovew_data[index].priceArr.length
    g_ovew_data[index].newPrice = parseFloat(b_price).toFixed(2)
    g_ovew_data[index].LXprice = parseFloat(b_LXprice).toFixed(2)
    if (j < priceLength) {
        g_ovew_data[index].priceArr[priceLength - 1] = parseFloat(b_price).toFixed(priceDecimal);
        g_ovew_data[index].LXpriceArr[priceLength - 1] = parseFloat(b_LXprice).toFixed(priceDecimal);
        g_ovew_data[index].vol[priceLength - 1] = Number(b_volume) - Number(g_ovew_data[index].nvolume[priceLength - 2]);
        g_ovew_data[index].nvolume[priceLength - 1] = b_volume
    } else if (j == g_ovew_data[index].priceArr.length) {
        g_ovew_data[index].priceArr.push(parseFloat(b_price).toFixed(priceDecimal));
        g_ovew_data[index].LXpriceArr.push(parseFloat(b_LXprice).toFixed(priceDecimal));
        g_ovew_data[index].nvolume.push(b_volume)
        g_ovew_data[index].vol.push(Number(b_volume) - Number(g_ovew_data[index].nvolume[priceLength - 2]));
    } else {
        for (k = priceLength; k < j; k++) {
            let last_price = g_ovew_data[index].priceArr[priceLength - 1] == undefined ? g_ovew_data[index].yestclose : g_ovew_data[index].priceArr[priceLength - 1]
            let LXlast_price = g_ovew_data[index].LXpriceArr[priceLength - 1] == undefined ? last_price : g_ovew_data[index].LXpriceArr[priceLength - 1]
            g_ovew_data[index].priceArr.push(last_price);
            g_ovew_data[index].LXpriceArr.push(LXlast_price);
            g_ovew_data[index].vol.push("0");
            g_ovew_data[index].nvolume.push(g_ovew_data[index].nvolume[priceLength - 1])
        }
        g_ovew_data[index].priceArr.push(parseFloat(b_price).toFixed(priceDecimal));
        g_ovew_data[index].LXpriceArr.push(parseFloat(b_LXprice).toFixed(priceDecimal));
        g_ovew_data[index].nvolume.push(b_volume)
        g_ovew_data[index].vol.push(Number(b_volume) - Number(g_ovew_data[index].nvolume[priceLength - 2]));

    }
    let volumechange = Number(b_volume) - Number(g_ovew_data[index].nvolume[priceLength - 2])
    SetOvewMaxMin(Number(b_price).toFixed(2), volumechange, index)
    SetOvewMaxMin(Number(b_LXprice).toFixed(2), volumechange, index)
    BalanceOvewMaxMin(index);
    if (index == 0) {
        g_ovewChart0.setOption(initOvewOption(g_ovew_data[0]));
    } else if (index == 1) {
        g_ovewChart1.setOption(initOvewOption(g_ovew_data[1]));
    } else if(index == 2) {
        g_ovewChart2.setOption(initOvewOption(g_ovew_data[2]));
    } 

}








function makePlateUperThree(data,num) {
    if(data.length == 0) {
        return
    }
    let html = ''
    for(let i=0;i<3;i++) {
        let plate = ReZhplateCHName(data[i]['IndexID'])
        let syscode1 = codeAndExidToSyscode(data[i].SecurityID1,data[i].ExchangeID1) 
        let syscode2 = codeAndExidToSyscode(data[i].SecurityID2,data[i].ExchangeID2) 
        let syscode3 = codeAndExidToSyscode(data[i].SecurityID3,data[i].ExchangeID3) 
        html+='<li class="over-plate-content-item">'
        html+='<div class="over-plate-itemname">'+plate+'</div>'
        html+='<div class="over-plate-itemname">'+(data[i].UpDownRate * 100).toFixed(2) +'%</div>'
        html+='<div class="over-plate-itemname cursor codeColor"><span onclick="rechartSysCode(\'' + syscode1 + '\',2)">'+data[i].SecurityName1+'</span>|<span onclick="rechartSysCode(\'' + syscode2 + '\',2)">'+data[i].SecurityName2+'</span>|<span onclick="rechartSysCode(\'' + syscode3 + '\',2)">'+data[i].SecurityName3+'</span></div>'
        html+='</li>'
    }
    if(num == 1) {
        $('#overPlateUp').html(html)
    } else {
        $('#overPlateDown').html(html)
    }
}


//板块龙头前三
let ovewFirstThree = []

function makeOvewFirstThree(data) {
    if(data.length == 0) {
        return
    }
    let html = ''
    for(let i=0;i<3;i++) {
        let syscode = codeAndExidToSyscode(data[i].SecurityID,data[i].ExchangeID) 
        let plate = ReInstrumentName(syscode)
        let ltCode = ReZhplateCHName(data[i].IndexID1)
        html+='<li class="over-plate-content-item">'
        html+='<div class="over-First-itemname cursor codeColor" onclick="rechartSysCode(\'' + syscode + '\',2)">'+plate+'</div>'
        html+='<div class="over-First-itemname">'+data[i].ConUpperLimitNum+'</div>'
        html+='<div class="over-First-itemname">'+ltCode+'</div>'
        html+='</li>'
    }
    $('#overFirstThree').html(html)
}



function dateFormat(date) {
    function addDataZero(num) {
      return (num < 10 ? '0'+num : num)
    }
    const d = new Date(date)
    const formatDate = `${d.getFullYear()}${addDataZero(d.getMonth()+1)}${addDataZero(d.getDate())}`
    return formatDate
}
function makeOvewAllMsg() {
    let end = dateFormat(new Date())
    let startTime = new Date().getTime() - 3600 * 1000 * 24 * 7
    let start = dateFormat(startTime)
    $.ajax({
        url: 'https://app.chinahxzq.com.cn:9302/index-api/news/flash/top?n=10',
        type: 'get',
        timeout: 3000,
        success: function (data) {
            const addrs = data.data
            let html = ''
            for(let i=0;i<addrs.length;i++) {
                let item = addrs[i]
                html+='<div class="over-massage-item" onclick="toNews(' + JSON.stringify(item).replace(/"/g, '&quot;') + ')">'
                html+='<span>'+item.time.split(' ')[1].substring(0,5)+'</span>'
                html+='<span>'+item.title+'</div>'
                html+='</div>'
            }
            $('#overContentItemside1').html(html)
        },
        error: function(err) {
        }
    })
    $.ajax({
        url: 'https://app.chinahxzq.com.cn:9302/financial-calendar/stockComment/list?page=0&size=10',
        type: 'get',
        timeout: 3000,
        success: function (data) {
            const addrs = data.data
            let template = `
                ${addrs.map((item,index) => `
                    <div class="over-massage-item" onclick="observe('${item.id}')">
                        <span>${ObsplitTime(item.date)}  ${item.time}</span>
                        <span>${item.title}</span>
                    </div>  
                    `).join('')}  
            `
            $('#overContentItemside2').html(template)
        },
        error: function(err) {
        }
    })
    $.ajax({
        url: 'https://app.chinahxzq.com.cn:9302/financial-calendar/event/list?startDate='+start+'&endDate='+end,
        type: 'get',
        timeout: 3000,
        success: function (data) {
            const addrs = data.data
            let template = `
                ${addrs.map((item,index) => `
                    <div class="over-massage-item1" onclick="Trigger_Event('${item.id}','${item.newsType}')">
                        <span class=${item.newsType===1 ? 'over-massage-itemType': 'over-massage-itemType1'}>${item.newsType===1 ? '新闻': '指标'}</span>
                        <span>${item.title}</span>
                        <span>${ObsplitTime(item.date)}</span>
                    </div>  
                    `).join('')}  
            `
            $('#overContentItemside3').html(template)
        },
        error: function(err) {
        }
    })
    $.ajax({
        url: 'https://app.chinahxzq.com.cn:9302/starway-api/app/news/queryMacroInsightNews',
        type: 'post',
        timeout: 3000,
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        data:{
            pageNum:1,
            pageSize:10
        },
        success: function (data) {
            const addrs = data.data.data
            let template = `
                ${addrs.map((item,index) => `
                    <div class="over-massage-item" onclick="WinDowExternalMag('${item.newsContent}')">
                        <span>${item.newsOriginalTime}</span>
                        <span>${item.newsTitle}</span>
                    </div>  
                    `).join('')}  
            `
            $('#overContentItemside4').html(template)
        },
        error: function(err) {
        }
    })
}
// makeOvewAllMsg()

function WinDowExternalMag(url) {
    window_external.Page_SendMsg(url)
}

//请求

let zhplate_insturmentIDUpIndex
let zhplate_insturmentIDDownIndex
let uplimit_insturmentIDIndex

let zhplate_insturmentIDUpIndex1
let zhplate_insturmentIDDownIndex1
let uplimit_insturmentIDIndex1


let zhplateHistoryList = []
let zhplateHistoryList1 = []
let zhOvewHistoryList = []
let g_nearTendaysTableType = true
let g_nearTendaysPlate = []
let nearTendaysUpTable = []
let nearTendaysDownTable = []
let g_nearTendaysTableType1 = true
let g_nearTendaysPlate1 = []
let nearTendaysUpTable1 = []
let nearTendaysDownTable1 = []
let todayDate = getToday()
let loginTypeNum = 0
let g_isfirstChartData = true
function Trigger_CQCRsp(key,data) {
    let kdata = JSON.parse(data)
    let jsonData =kdata.dataTx
    if(key == 1) {  //查询行业板块列表
        if(kdata.isPageLast == 'false'){
            T_ZhPlateList.push(jsonData)
        }
    } else if(key == 2) {   //查询概念板块列表
        if(kdata.isPageLast == 'false'){
            T_ZhPlateList.push(jsonData)
        }
    } else if(key == 22) {  //行业板块热门排名
        g_nearTendaysTableType = false
        if(kdata.isLast == 'false') {
            g_nearTendaysPlate.push(jsonData.IndexName)
        }
    } else if(key == 23) {  //概念板块热门排名
        g_nearTendaysTableType1 = false
        if(kdata.isLast == 'false') {
            g_nearTendaysPlate1.push(jsonData.IndexName)
        }
    } else if(key == 18) {   //查询近十日行业板块涨幅排名
        if(kdata.isLast == 'false') {
            nearTendaysUpTable.push(jsonData)
        }
        
    } else if(key == 19) {  //查询近十日行业板块跌幅排名
        if(kdata.isLast == 'false') {
            nearTendaysDownTable.push(jsonData)
        }
    } else if(key == 20) {   //查询近十日概念板块涨幅排名
        if(kdata.isLast == 'false') {
            nearTendaysUpTable1.push(jsonData)
        }
        
    } else if(key == 21) {  //查询近十日概念板块跌幅排名
        if(kdata.isLast == 'false') {
            nearTendaysDownTable1.push(jsonData)
        }
    } else if(key == 25) {    // 行业历史分钟线 
        if(kdata.isLast == 'false') {
            zhplateHistoryList.push(jsonData) 
        }
        if(kdata.isLast == "true") {

            if(zhplateHistoryList.length == 0) {
                return
            }
            let syscode = zhplateHistoryList[0].IndexID

            let prePrice = ReZhplatePerClose(syscode)
            let size = zhplateHistoryList.length
            let times = zhplateHistoryList.map((item) => item['IndexTime']).join(',')
            
            let price = zhplateHistoryList.map((item) => item.IndexPoint).join(',')
            let volume = zhplateHistoryList.map((item) => Number(item.TotalVolume)).join(',')
            let volumechange = zhplateHistoryList.map((item) => Number(item.Volume)).join(',')
            if (Page_Module == 'overview') {
                if(g_ovewMainType == 'zhplate'){
                    if(zhplateShowType == 'UpDownType') {
                        if(zhplate_insturmentIDUpArray.includes(syscode)) {
                            zhplate_insturmentIDUpIndex++
                            if(zhplate_insturmentIDUpIndex<10) {
                                window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDUpArray[zhplate_insturmentIDUpIndex]}))
                            } else if(zhplate_insturmentIDUpIndex == 10) {
                                window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDDownArray[0]}))
                            }
                            Trigger_Mzhplate_History(syscode, times, price, volume, volumechange, size, prePrice,1)
                            
                        } 
                        if(zhplate_insturmentIDDownArray.includes(syscode)) {
                            zhplate_insturmentIDDownIndex++
                            if(zhplate_insturmentIDDownIndex<10) {
                                window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDDownArray[zhplate_insturmentIDDownIndex]}))
                            }
                            Trigger_Mzhplate_History1(syscode, times, price, volume, volumechange, size, prePrice,1)
                        }
                    } else if(zhplateShowType == 'UpLimitType'){
                        if(uplimit_insturmentIDArray.includes(syscode)) {
                            uplimit_insturmentIDIndex++
                            if(uplimit_insturmentIDIndex < 10) {
                                window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":uplimit_insturmentIDArray[uplimit_insturmentIDIndex]}))
                            }
                            Trigger_Muplimit_History(syscode, times, price, volume, volumechange, size, prePrice,1)
                        }
                        
                    }
                }
                
            } else if(Page_Module == 'SinglePlate') {
                
                Trigger_singlePlate_History(syscode, times, price, volume, volumechange, size, prePrice)
            }
            zhplateHistoryList = []
        }
    } else if(key == 26) {    // 概念历史分钟线 
        if(kdata.isLast == 'false') {
            zhplateHistoryList1.push(jsonData) 
        }
        if(kdata.isLast == "true") {
            if(zhplateHistoryList1.length == 0) {
                return
            }
            let syscode = zhplateHistoryList1[0].IndexID

            let prePrice = ReZhplatePerClose(syscode)
            let size = zhplateHistoryList1.length
            let times = zhplateHistoryList1.map((item) => item['IndexTime']).join(',')
            
            let price = zhplateHistoryList1.map((item) => item.IndexPoint).join(',')
            let volume = zhplateHistoryList1.map((item) => Number(item.TotalVolume)).join(',')
            let volumechange = zhplateHistoryList1.map((item) => Number(item.Volume)).join(',')
            if (Page_Module == 'overview') {
                if(g_ovewMainType == 'zhplate1'){
                    if(zhplateShowType == 'UpDownType') {
                        if(zhplate_insturmentIDUpArray1.includes(syscode)) {
                            zhplate_insturmentIDUpIndex1++
                            if(zhplate_insturmentIDUpIndex1<10) {
                                window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDUpArray1[zhplate_insturmentIDUpIndex1]}))
                            } else if(zhplate_insturmentIDUpIndex1 == 10) {
                                window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDDownArray1[0]}))
                            }
                            Trigger_Mzhplate_History(syscode, times, price, volume, volumechange, size, prePrice,2)
                        } 
                        if(zhplate_insturmentIDDownArray1.includes(syscode)) {
                            zhplate_insturmentIDDownIndex1++
                            if(zhplate_insturmentIDDownIndex1<10) {
                                window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDDownArray1[zhplate_insturmentIDDownIndex1]}))
                            }
                            Trigger_Mzhplate_History1(syscode, times, price, volume, volumechange, size, prePrice,2)
                        }
                    } else if(zhplateShowType == 'UpLimitType'){
                        if(uplimit_insturmentIDArray1.includes(syscode)) {
                            uplimit_insturmentIDIndex1++
                            if(uplimit_insturmentIDIndex1 < 10) {
                                window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":uplimit_insturmentIDArray1[uplimit_insturmentIDIndex1]}))
                            }
                            Trigger_Muplimit_History(syscode, times, price, volume, volumechange, size, prePrice,2)
                        }
                        
                    }
                }
                
            } else if(Page_Module == 'SinglePlate') {
                
                Trigger_singlePlate_History(syscode, times, price, volume, volumechange, size, prePrice)
            }
            zhplateHistoryList1 = []
        }
    } else if(key == 41) {  //股票指数历史分钟线
        if(kdata.isLast == 'false') {
            zhOvewHistoryList.push(jsonData) 
        }
        if(kdata.isLast == "true") {
            if(zhOvewHistoryList.length == 0) {
                return
            }
            let ExchangeType = zhOvewHistoryList[0].ExchangeID == 1 ? '.SH' : '.SZ'
            let syscode = zhOvewHistoryList[0].SecurityID+ExchangeType

            let prePrice = ReMarketPrePrice(syscode)
            let size = zhOvewHistoryList.length
            let times = zhOvewHistoryList.map((item) => item.UpdateTime).join(',')
            let price = zhOvewHistoryList.map((item) => item.ClosePrice).join(',')
            let LXprice = zhOvewHistoryList.map((item) => item.LXClosePrice).join(',')
            let volume = zhOvewHistoryList.map((item) => Number(item.TotalVolume)).join(',')
            let volumechange = zhOvewHistoryList.map((item) => Number(item.Volume)).join(',')
            if (Page_Module == 'overview') {
                if(g_ovewMainType == 'overview'){
                    if(ovew_insturmentIDArray.includes(syscode)) {
                        ovew_insturmentIDIndex++
                        if(ovew_insturmentIDIndex < 3) {
                            window_external.Page_CQCReq('41',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","indexCode":ovew_insturmentIDArray[ovew_insturmentIDIndex]}))
                        }
                        Trigger_Movew_History(syscode, times, price, LXprice, volume, volumechange, size, prePrice)
                    }
                }               
            } 
            zhOvewHistoryList = []
        }
    } else if(key == 7) {   //查询行业板块成分股
        if(kdata.isLast == 'false') { 
            let sysCode = codeAndExidToSyscode(jsonData.SecurityID,jsonData.ExchangeID)
            let obj = {}
            obj['sysCode'] = sysCode
            obj['instrumentName'] = ReInstrumentName(sysCode);
            obj['upDown'] = '—';
            obj['upDownRatio'] = '—';
            obj['lastPrice'] = '—';
            obj['preClosePrice'] = '—';
            obj['openPrice'] = '—';
            obj['highestPrice'] = '—';
            obj['lowestPrice'] = '—';
            obj['upperLimitPrice'] = '—';
            obj['lowerLimitPrice'] = '—';
            obj['volume'] = '—';
            obj['turnover'] = '—';
            obj['bidPrice1'] = '—';
            obj['askPrice1'] = '—';
            obj['BidVolume1'] = '—';
            obj['AskVolume1'] = '—';
            T_plateList.push(obj)
        }
        if(kdata.isLast == "true") {
            
            // Page_Module = "plateHtml"
            // window.location.hash = '/plateHtml'
            // $('.sideItem').removeClass('active')
            // $('#appMain').html(plateHtml)
            // $('.content_main').css("width", bodyWidth + 'px')
            // let plateName = ReZhplateCHName(syscode)
            // $('#plate_titleName').html(syscode + ' ' + plateName)
            stock_startNum = 0
            stock_visibleCount = Math.ceil(stockviewH / itemSize) + 4 //展示的数量
            stock_endNum = stock_startNum + stock_visibleCount
            listHeight = T_plateList.length * itemSize
            let stockList = T_plateList.slice(stock_startNum, stock_endNum)
            let SysCodeListStr = stockList.map(item => item.sysCode).join(',')
            Make_stock(stockList)
            Make_stockListNav(stockShowNavList)
            let showLen = stockShowNavList.length
            $('.tableNav_right').css('minWidth',(showLen * 90 + 220)+'px')
            $('.infinite-list-content').css('minWidth',(showLen * 90 + 220)+'px')
            window_external.Page_Subscribe(SysCodeListStr)
            // if(zhOvewHistoryList.length == 0) {
            //     return
            // }
            // let ExchangeType = zhOvewHistoryList[0].ExchangeID == 1 ? '.SH' : '.SZ'
            // let syscode = zhOvewHistoryList[0].SecurityID+ExchangeType

            // let prePrice = ReMarketPrePrice(syscode)
            // let size = zhOvewHistoryList.length
            // let times = zhOvewHistoryList.map((item) => item.UpdateTime).join(',')
            // let price = zhOvewHistoryList.map((item) => item.ClosePrice).join(',')
            // let LXprice = zhOvewHistoryList.map((item) => item.LXClosePrice).join(',')
            // let volume = zhOvewHistoryList.map((item) => Number(item.TotalVolume)).join(',')
            // let volumechange = zhOvewHistoryList.map((item) => Number(item.Volume)).join(',')
            // if (Page_Module == 'overview') {
            //     if(g_ovewMainType == 'overview'){
            //         if(ovew_insturmentIDArray.includes(syscode)) {
            //             Trigger_Movew_History(syscode, times, price, LXprice, volume, volumechange, size, prePrice)
            //         }
            //     }
                
            // } 
            // zhOvewHistoryList = []
        }

    }
}

const throttleGetZhPlateUPTen = throttle(getZhPlateUPTenDetail,300000)

function getZhPlateUPTenDetail(data) {
    zhplate_insturmentIDUpIndex = 0
    let kdata = resetJsonToStr(data)
    let jsonData = kdata.dataTx
    window_external.Page_CQCReq('13',JSON.stringify(zhplate_insturmentIDUpArray))
    zhplate_insturmentIDUpArray = []
    zhplate_insturmentUpArray = []
    for(let i=0;i<jsonData.length;i++) {
        zhplate_insturmentIDUpArray.push(jsonData[i].IndexID)
        zhplate_insturmentUpArray.push(jsonData[i])
    }
    if(Page_Module == 'overview') {
        if(g_ovewMainType == 'overview') {
            makePlateUperThree(zhplate_insturmentUpArray,1)
        } else if(g_ovewMainType == 'zhplate'){
            window_external.Page_CQCReq('10',JSON.stringify(zhplate_insturmentIDUpArray))
            // for(let i=0;i<zhplate_insturmentIDUpArray.length;i++){
            //     // setTimeout(function() {
            //         window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDUpArray[i]}))
            //     // },i*50)
                
            // }
            window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDUpArray[0]}))
            getZhPlateUPTen(zhplate_insturmentUpArray)
        }
    }
}

const throttleGetZhPlateDownTen = throttle(getZhPlateDownTenDetail,300000)



function getZhPlateDownTenDetail(data) {
    zhplate_insturmentIDDownIndex = 0
    let kdata = resetJsonToStr(data)
    let jsonData = kdata.dataTx
    window_external.Page_CQCReq('13',JSON.stringify(zhplate_insturmentIDDownArray))
    zhplate_insturmentIDDownArray = []
    zhplate_insturmentDownArray = []
    for(let i=0;i<jsonData.length;i++) {
        zhplate_insturmentIDDownArray.push(jsonData[i].IndexID)
        zhplate_insturmentDownArray.push(jsonData[i])
    }
    if(Page_Module == 'overview') {
        if(g_ovewMainType == 'overview') {
            makePlateUperThree(zhplate_insturmentDownArray,2)
        } else if(g_ovewMainType == 'zhplate'){
                // for(let i=0;i<zhplate_insturmentIDDownArray.length;i++){
                //     setTimeout(() =>{
                //         window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDDownArray[i]}))
                //     },i*100)
                // }
            // window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDDownArray[0]}))
            window_external.Page_CQCReq('10',JSON.stringify(zhplate_insturmentIDDownArray))
            getZhPlateDownTen(zhplate_insturmentDownArray)
        }
    }
}

const throttleGetZhPlateUpperLimit = throttle(getZhPlateUpperLimitTenDetail,300000)
function getZhPlateUpperLimitTenDetail(data) {
    uplimit_insturmentIDIndex = 0
    let kdata = resetJsonToStr(data)
    let jsonData = kdata.dataTx
    window_external.Page_CQCReq('13',JSON.stringify(uplimit_insturmentIDArray))
    uplimit_insturmentIDArray = []
    uplimit_insturmentArray = []
    for(let i=0;i<jsonData.length;i++) {
        uplimit_insturmentIDArray.push(jsonData[i].IndexID)
        uplimit_insturmentArray.push(jsonData[i])
    }
    if(Page_Module == 'overview' && g_ovewMainType == 'zhplate' && zhplateShowType == 'UpLimitType') {
        window_external.Page_CQCReq('10',JSON.stringify(uplimit_insturmentIDArray))
        // for(let i=0;i<uplimit_insturmentIDArray.length;i++){
        //     setTimeout(() =>{
        //         window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":uplimit_insturmentIDArray[i]}))
        //     },i*100)
        // }
        window_external.Page_CQCReq('25',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":uplimit_insturmentIDArray[0]}))
        getZhPlateUpperLimitTen(uplimit_insturmentArray)
    }
}

const throttleGetZhPlateUPTen1 = throttle(getZhPlateUPTenDetail1,300000)

function getZhPlateUPTenDetail1(data) {
    zhplate_insturmentIDUpIndex1 = 0
    let kdata = resetJsonToStr(data)
    let jsonData = kdata.dataTx
    window_external.Page_CQCReq('14',JSON.stringify(zhplate_insturmentIDUpArray1))
    zhplate_insturmentIDUpArray1 = []
    zhplate_insturmentUpArray1 = []
    for(let i=0;i<jsonData.length;i++) {
        zhplate_insturmentIDUpArray1.push(jsonData[i].IndexID)
        zhplate_insturmentUpArray1.push(jsonData[i])
    }
    if(Page_Module == 'overview') {
        if(g_ovewMainType == 'overview') {
            makePlateUperThree(zhplate_insturmentUpArray1,1)
        } else if(g_ovewMainType == 'zhplate1'){
            window_external.Page_CQCReq('11',JSON.stringify(zhplate_insturmentIDUpArray1))
            // for(let i=0;i<zhplate_insturmentIDUpArray1.length;i++){
            //     // setTimeout(function() {
            //         window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDUpArray1[i]}))
            //     // },i*50)
                
            // }
            window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDUpArray1[0]}))
            getZhPlateUPTen(zhplate_insturmentUpArray1)
        }
    }
}

const throttleGetZhPlateDownTen1 = throttle(getZhPlateDownTenDetail1,300000)

function getZhPlateDownTenDetail1(data) {
    zhplate_insturmentIDDownIndex1 = 0
    let kdata = resetJsonToStr(data)
    let jsonData = kdata.dataTx
    window_external.Page_CQCReq('14',JSON.stringify(zhplate_insturmentIDDownArray1))
    zhplate_insturmentIDDownArray1 = []
    zhplate_insturmentDownArray1 = []
    for(let i=0;i<jsonData.length;i++) {
        zhplate_insturmentIDDownArray1.push(jsonData[i].IndexID)
        zhplate_insturmentDownArray1.push(jsonData[i])
    }
    if(Page_Module == 'overview') {
        if(g_ovewMainType == 'overview') {
            makePlateUperThree(zhplate_insturmentDownArray1,2)
        } else if(g_ovewMainType == 'zhplate1'){
                // for(let i=0;i<zhplate_insturmentIDDownArray1.length;i++){
                //     setTimeout(() =>{
                //         window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":zhplate_insturmentIDDownArray1[i]}))
                //     },i*100)
                // }
                window_external.Page_CQCReq('11',JSON.stringify(zhplate_insturmentIDDownArray1))
            getZhPlateDownTen(zhplate_insturmentDownArray1)
        }
    }
}

const throttleGetZhPlateUpperLimit1 = throttle(getZhPlateUpperLimitTenDetail1,300000)
function getZhPlateUpperLimitTenDetail1(data) {
    uplimit_insturmentIDIndex1 = 0
    let kdata = resetJsonToStr(data)
    let jsonData = kdata.dataTx
    window_external.Page_CQCReq('14',JSON.stringify(uplimit_insturmentIDArray1))
    uplimit_insturmentIDArray1 = []
    uplimit_insturmentArray1 = []
    for(let i=0;i<jsonData.length;i++) {
        uplimit_insturmentIDArray1.push(jsonData[i].IndexID)
        uplimit_insturmentArray1.push(jsonData[i])
    }
    if(Page_Module == 'overview' && g_ovewMainType == 'zhplate1' && zhplateShowType == 'UpLimitType') {
        window_external.Page_CQCReq('11',JSON.stringify(uplimit_insturmentIDArray1))
        // for(let i=0;i<uplimit_insturmentIDArray1.length;i++){
        //     setTimeout(() =>{
        //         window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":uplimit_insturmentIDArray1[i]}))
        //     },i*100)
        // }
        window_external.Page_CQCReq('26',JSON.stringify({"BeginDate":todayDate,"EndDate":todayDate,"BeginTime":"09:30","EndTime":"23:59","IndexID":uplimit_insturmentIDArray1[0]}))
        getZhPlateUpperLimitTen(uplimit_insturmentArray1)
    }
}


function resetJsonToStr(str) {
    let splitStr = str.split('"{').join('{')
    let joinStr = splitStr.split('}"').join('}')
    return JSON.parse(joinStr)
}

//推送
function Trigger_CQCRtn(key,data) {
    if(key == 27) {   //行业板块涨幅排名
        throttleGetZhPlateUPTen(data)    
    } else if(key == 31) {   //行业板块跌幅排名
        throttleGetZhPlateDownTen(data)
    } else if(key == 35) {   //行业板块涨停家数排名 
        throttleGetZhPlateUpperLimit(data)
    } else if(key == 29) {   //概念板块涨幅排名
        throttleGetZhPlateUPTen1(data)    
    } else if(key == 33) {   //概念板块跌幅排名
        throttleGetZhPlateDownTen1(data)
    } else if(key == 37) {   //概念板块涨停家数排名 
        throttleGetZhPlateUpperLimit1(data)
    } else if(key == 16) { //大盘龙头数据
        let kdata = JSON.parse(data)
        let jsonData = kdata.dataTx
        if(jsonData.Rank == 1) {
            ovewFirstThree = []
        }
        if(kdata.isLast == 'false') {
            ovewFirstThree.push(jsonData)
            if(jsonData.Rank == 10){
                makeOvewFirstThree(ovewFirstThree)
            }
        }
    } else if(key == 10) {   //行业板块切片行情
        const sdata = JSON.parse(data).dataTx
        let InstrumentID = sdata.IndexID
        let PreClosePrice = sdata.PreClosePoint
        let UpdateTime = sdata.UpdateTime
        let TradingDay = sdata.TradingDay
        let LastPrice = sdata.IndexPoint
        let Volume = Number(sdata.Volume)
        if(g_ovewMainType == 'zhplate') {
            if(zhplateShowType == 'UpDownType') {
                if(zhplate_insturmentIDUpArray.includes(InstrumentID)) {
                    let index = CheckId_zhplate(InstrumentID,1)
                    Trigger_zhplatePrePrice(PreClosePrice, index)
                    let IndexHistory = zhplatehaveHistory(InstrumentID)
                    if (IndexHistory && Number(LastPrice) > 0) {
                        Trigger_Mzhplate_Now(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay,1)
                    }
                } else if(zhplate_insturmentIDDownArray.includes(InstrumentID)) {
                    let index = CheckId_zhplate1(InstrumentID,1)
                    Trigger_zhplatePrePrice1(PreClosePrice, index)
                    let IndexHistory = zhplatehaveHistory1(InstrumentID)
                    if (IndexHistory && Number(LastPrice) > 0) {
                        Trigger_Mzhplate_Now1(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay,1)
                    }
                }
            } else if(zhplateShowType == 'UpLimitType'){
              let index = CheckId_uplimit(InstrumentID,1)
              Trigger_uplimitPrePrice(PreClosePrice, index)
              let IndexHistory = uplimithaveHistory(InstrumentID)
              if (IndexHistory && Number(LastPrice) > 0) {
                Trigger_Muplimit_Now(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay,1)
              }
            }
        }
        if(Page_Module == 'SinglePlate'){
            if (g_havesinglePlateHistory && Number(LastPrice) > 0) {
                if (InstrumentID != singlePlate_insturmentID) {
                    return
                }
                Trigger_MsinglePlate_Now(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay)
            }
        }
    } else if(key == 11) {   //概念板块切片行情
        const sdata = JSON.parse(data).dataTx
        let InstrumentID = sdata.IndexID
        let PreClosePrice = sdata.PreClosePoint
        let UpdateTime = sdata.UpdateTime
        let TradingDay = sdata.TradingDay
        let LastPrice = sdata.IndexPoint
        let Volume = Number(sdata.Volume)
        if(g_ovewMainType == 'zhplate1') {
            if(zhplateShowType == 'UpDownType') {
                if(zhplate_insturmentIDUpArray.includes(InstrumentID)) {
                    let index = CheckId_zhplate(InstrumentID,2)
                    Trigger_zhplatePrePrice(PreClosePrice, index)
                    let IndexHistory = zhplatehaveHistory(InstrumentID)
                    if (IndexHistory && Number(LastPrice) > 0) {
                        Trigger_Mzhplate_Now(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay,2)
                    }
                } else if(zhplate_insturmentIDDownArray.includes(InstrumentID)) {
                    let index = CheckId_zhplate1(InstrumentID,2)
                    Trigger_zhplatePrePrice1(PreClosePrice, index)
                    let IndexHistory = zhplatehaveHistory1(InstrumentID)
                    if (IndexHistory && Number(LastPrice) > 0) {
                        Trigger_Mzhplate_Now1(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay,2)
                    }
                }
            } else if(zhplateShowType == 'UpLimitType'){
              let index = CheckId_uplimit(InstrumentID,2)
              Trigger_uplimitPrePrice(PreClosePrice, index)
              let IndexHistory = uplimithaveHistory(InstrumentID)
              if (IndexHistory && Number(LastPrice) > 0) {
                Trigger_Muplimit_Now(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay,2)
              }
            }
        }
        if(Page_Module == 'SinglePlate'){
            if (g_havesinglePlateHistory && Number(LastPrice) > 0) {
                if (InstrumentID != singlePlate_insturmentID) {
                    return
                }
                Trigger_MsinglePlate_Now(InstrumentID, UpdateTime, LastPrice, Volume, TradingDay)
            }
        }
    } else if(key == 39) {
        const sdata = JSON.parse(data).dataTx
        let ExchangeType = sdata.ExchangeID == 1 ? '.SH' : '.SZ'
        let InstrumentID = sdata.SecurityID+ExchangeType
        let PreClosePrice = sdata.PreClosePrice
        let UpdateTime = sdata.UpdateTime
        let TradingDay = sdata.TradingDay
        let LastPrice = sdata.LastPrice
        let LXLastPrice =  sdata.LXLastPrice
        let Volume = Number(sdata.Volume)
        if(Page_Module == 'overview' && g_ovewMainType == 'overview') {
            let index = CheckId_Ovew(InstrumentID)
            Trigger_OvewPrePrice(PreClosePrice, index)
            let IndexHistory = OvewhaveHistory(InstrumentID)
            if (IndexHistory && Number(LastPrice) > 0) {
                Trigger_Movew_Now(InstrumentID, UpdateTime, LastPrice, LXLastPrice, Volume, TradingDay)
            }
        }
        
    }
}