﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MarketDll
{
    /// <summary>
    /// /////////////////外部使用/////////////////
    /// </summary>
    public delegate void Rtn_ClickPrice(string syscode, double price);   //点击价格显示交易窗口
    //public delegate void Rtn_ClickFollow(int UserControlID, bool bFollow);
    //public delegate void Rtn_Key(int UserControlID, int code);
    //public delegate void Rtn_ClickMarket(string syscode, string name);
    public delegate void Rtn_CancelOrder(string syscode, eSysType sys, string key); //撤单
    public delegate void Rtn_ChangeOrder(string syscode, eSysType sys, string key, string price);   //改单 price为""表示尚未指定价格
    //public delegate void Rtn_KeyDown(char key);
    public delegate void Rtn_KeyDown(int keycode);
    public delegate void Rtn_Setting(); //调出设置对话框
    public delegate void Rtn_S05_UptTWAPOrderVolumeDetail(stS05OrderVolume para);    //设置S05分笔成交量

    public struct stGlobalSetting
    {
        public string sIP;  //行情服务器IP
        public int iPort;   //行情服务器端口
        public string sServerPath;  //策略服务器IFrame http://starway.cfsc.com.cn:9112/starway-pc/
        //查pb,pe等
        public string sURL1;    //http://app.shchinafortune.com:8088/news-center/stock/f10/concept/
        //查新闻和公告
        public string sURL2;    //http://app.shchinafortune.com:8088/news-center/news/
        //首页
        public string sURL3;    //http://starway.cfsc.com.cn:9112/api/stock/top10  //涨跌榜
        public string sURL4;    //https://starway.cfsc.com.cn:9110/index-api/news/flash/top    // 获取7x24新闻资讯
        public string sURL5;    //https://starway.cfsc.com.cn:9110/financial-calendar/stockComment/list      // 获取哈勃观察列表
        public string sURL6;    //https://starway.cfsc.com.cn:9110/financial-calendar/stockComment/detail    // 获取哈勃观察详情
        public string sURL7;    //http://starway.cfsc.com.cn:9112/api/stock/updowndetailcount2    //涨跌总览
        //K1
        public string sURL8;    //https://starway.cfsc.com.cn:9110/index-api/index/stock/fundsFlow/day   //查询5天的数据
        public string sURL9;    //https://starway.cfsc.com.cn:9110/index-api/index/stock/fundsFlow/min  //查询当天的数据
        public string sURL10;   //http://starway.cfsc.com.cn:9112/api/stock/sectorlistName4stock              //查询板块数据
        public string sURL11;   //https://starway.cfsc.com.cn:9110/ifa-agent/stock/summary                      //查询诊股数据
        public string sURL12;   //http://starway.cfsc.com.cn:9112/news-center/stock/f10/finance //查询财务数据
        public string sURL13;   //http://starway.cfsc.com.cn:9112/news-center/stock/f10/profile/shareholder //查询资料数据1
        public string sURL14;   //http://starway.cfsc.com.cn:9112/news-center/stock/f10/profile/circulateShareholder //查询资料数据2
        //K2
        public string sURL15;   //http://starway.cfsc.com.cn:9112/position_data/position  // 查询持仓趋势的数据
        public string sURL16;   //http://starway.cfsc.com.cn:9112/position_data/warehouse //查询仓单的数据
        public string sURL17;   //http://starway.cfsc.com.cn:9112/api/F10/futures //F10数据
        //K3
        public string sURL18;   //http://app.shchinafortune.com:8088/api/stock/updowndetailcount2  //涨跌总览
        //K1
        public string sURL19;   //http://starway.cfsc.com.cn:9112/news-center/stock/f10/profile   //资料数据
        //首页
        public string sURL20;   //https://starway.cfsc.com.cn:9110/index-api/index/stock/quotes  //查询涨跌
        //自选网址
        public string sURL21;   //http://app.shchinafortune.com:8088/user/portfolio/
        //获取板块内股票列表
        public string sURL22;   //https://starway.cfsc.com.cn:9302/api/stock/sectorMemberslist
        ///领涨/领跌板块列表
        public string sURL23;   //https://starway.cfsc.com.cn:9302/t1-api/stock/sector/top
        //板块实时行情
        public string sURL24;   //https://starwaylt.cfsc.com.cn:9302/t1-api/stock/sector/quotation
    }

    public struct stConfig
    {
        //是否显示行情的委托线和成交气泡
        public bool bShowOrderTrade_Stock;
        public bool bShowOrderTrade_Ctp;
        public bool bShowOrderTrade_Credit;
    }

    //行情模块参数
    public struct stMarketPara
    {
        public string sIndex_InstrumentIDArray;    //首页 SysCode 股票代码集合(逗号隔开) 如 000001.SH,399001.SZ,399006.SZ
        public string sIndex_InstrumentNameArray;  //首页 名称集合(逗号隔开) 如 上证指数,深证成指,创业板指
        public string sOption_InstrumentIDArray;    //期权 SysCode 股票代码集合(逗号隔开) 如 000300.SH,510050.SH,159919.SZ,510300.SH
        public string sOption_InstrumentNameArray;  //期权 名称集合(逗号隔开) 如 沪深300,上证50ETF,...
        public string sUserDefault_InstrumentIDArray;   //自选默认 SysCode 股票代码集合(逗号隔开) 
        public string sUserDefault_InstrumentNameArray; //自选默认 名称集合(逗号隔开)
    }

    //public struct stMarketInputPara
    //{
    //    public string sInstrumentID;    //SysCode,股票或者期货代码 如 600000.SH,002001.SZ, if1912
    //    public string sInstrumentName;  //名称 如中国石油
    //    public int iType;                  //1-k线图,2-分时图,3-S01,4-S02,5-S03
    //    public int iSubType;              //10-5分,11-1小时,12-1日,13-1周,14-1月,19-1分; 50-分时
    //    public int iWidth;              //宽度
    //    public int iHeight;             //高度
    //    public bool bFollow;             //是否自选股
    //    public int iLayout;             //0-不显示右侧 1-显示1个模块 2-显示2个模块
    //}

    public struct stMonitorIndexPara
    {
        public string sUserDefault_InstrumentIDArray;   //自选默认 SysCode 股票代码集合(逗号隔开) 
        public string sUserDefault_InstrumentNameArray; //自选默认 名称集合(逗号隔开)
    }

    public struct stS03Para
    {
        public string sInstrumentID;    //名称 au2010-au2011
        public string sNearFutureID;   //近期合约
        public string sFarFutureID;    //远期合约
    }

    public struct stS05Para
    {
        public string sCombOrderID;     //
        public string sInstrumentID;    //SysCode,股票代码 如 600000.SH,002001.SZ
        public string sInstrumentName;  //名称 如中国石油
        public int iType;               //类型 1-买 2-卖
        public int iOrderType;          //1-TPOV 2-TWAP 3-VWAP 4-TWAPOV
        public string sStartTime;       //空或者时间
        public string sEndTime;         //空或者时间
        public int iTarget;             //目标总量
        public int MinMarketOrderBuyVolume;
        public int MinMarketOrderSellVolume;
        public int MarketBuyTradingUnit;
        public int MarketSellTradingUnit;
    }

    public struct stS05OrderVolume
    {
        public string sOrderID;
        public string sTime;
        public int iVolume;
    }

    public struct stS07Para
    {
        public string sCombOrderID;     //
        public string sInstrumentID;    //SysCode,股票代码 如 600000.SH,002001.SZ
        public string sInstrumentName;  //名称 如中国石油
        public int iType;               //类型 1-买 2-卖
        public int iOrderType;          //1-TPOV 2-TWAP 3-VWAP
        public string sStartTime;       //空或者时间
        public string sEndTime;         //空或者时间
    }

    public struct stS07OrderVolume
    {
        public string sTime;
        public int iVolume;
    }

    //public struct stMarketIndexPage
    //{
    //    public string sInstrumentIDArray;    //SysCode 股票代码集合(逗号隔开) 如 000001.SH,399001.SZ,399006.SZ
    //    public string sInstrumentNameArray;  //名称集合(逗号隔开) 如 上证指数,深证成指,创业板指
    //}

    //public struct stOptionIndexPage
    //{
    //    public string sInstrumentIDArray;    //SysCode 股票代码集合(逗号隔开) 如 000300.SH,510050.SH,159919.SZ,510300.SH
    //    public string sInstrumentNameArray;  //名称集合(逗号隔开) 如 沪深300,上证50ETF,...
    //    public int iPageWidth;  //宽度
    //}

    public struct stSinglePage
    {
        public string sSyscode;
        public int iType;      //1-k线图,2-分时图
        public int iSubType;   //10-5分,11-1小时,12-1日,13-1周,14-1月,19-1分; 50-分时

        public void Init()
        {
            sSyscode = "";
            iType = 2;
            iSubType = 0;  //无效值
        }

        public bool Same(string syscode, int type, int subtype)
        {
            return ((sSyscode == syscode) && (iType == type) && (iSubType == subtype));
        }

        public bool SameSyscode(string syscode)
        {
            return (sSyscode == syscode);
        }

        public bool SameType(int type)
        {
            return (iType == type);
        }

        public bool SameSubType(int subtype)
        {
            return (iSubType == subtype);
        }

        public void Set(string syscode, int type, int subtype)
        {
            sSyscode = syscode;
            iType = type;
            iSubType = subtype;
        }
    }

    public struct BaseData_product
    {
        public string exchangeId;
        public string productId;
        public string productName;
        public string productType;
        public string productTypeName;
        public string priceTick;
        public string priceDecimal;
        public string volumeMultiple;
        public string segment;

        public BaseData_product(string exchangeId, string productId, string productName, string productType,
            string productTypeName, string priceTick, string priceDecimal, string volumeMultiple, string segment)
        {
            this.exchangeId = exchangeId;
            this.productId = productId;
            this.productName = productName;
            this.productType = productType;
            this.productTypeName = productTypeName;
            this.priceTick = priceTick;
            this.priceDecimal = priceDecimal;
            this.volumeMultiple = volumeMultiple;
            this.segment = segment;
        }
    }

    public struct BaseData_tradingday
    {
        public string exchangeId;
        public string tradingday;
        public string preTradingday;
        public string preTradingdayNextDay;

        public BaseData_tradingday(string exchangeId, string tradingday, string preTradingday, string preTradingdayNextDay)
        {
            this.exchangeId = exchangeId;
            this.tradingday = tradingday;
            this.preTradingday = preTradingday;
            this.preTradingdayNextDay = preTradingdayNextDay;
        }
    }

    public struct BaseData_instrument
    {
        public string sysCode;
        public string exchangeId;
        public string productId;
        public string instrumentId;
        public string instrumentName;
        public string instrumentAbbr;

        public BaseData_instrument(string sysCode, string exchangeId, string productId, string instrumentId,
            string instrumentName, string instrumentAbbr)
        {
            this.sysCode = sysCode;
            this.exchangeId = exchangeId;
            this.productId = productId;
            this.instrumentId = instrumentId;
            this.instrumentName = instrumentName;
            this.instrumentAbbr = instrumentAbbr;
        }
    }

    public struct BaseData_etf_options
    {
        public string sysCode;
        public string exchangeId;
        public string productId;
        public string contractId;
        public string instrumentId;
        public string strikePrice;
        public string changeVersion;
        public string changeVersionValue;
        public string optionsType;
        public string expireDate;

        public BaseData_etf_options(string sysCode, string exchangeId, string productId, string contractId,
            string instrumentId, string strikePrice, string changeVersion, string changeVersionValue,
            string optionsType, string expireDate)
        {
            this.sysCode = sysCode;
            this.exchangeId = exchangeId;
            this.productId = productId;
            this.contractId = contractId;
            this.instrumentId = instrumentId;
            this.strikePrice = strikePrice;
            this.changeVersion = changeVersion;
            this.changeVersionValue = changeVersionValue;
            this.optionsType = optionsType;
            this.expireDate = expireDate;
        }
    }


    public struct BaseData_futures_options
    {
        public string sysCode;
        public string exchangeId;
        public string productId;
        public string contractId;
        public string instrumentId;
        public string strikePrice;
        public string optionsType;
        public string expireDate;
        public string isAtTheMoneyOption;

        public BaseData_futures_options(string sysCode, string exchangeId, string productId, string contractId,
            string instrumentId, string strikePrice, string optionsType, string expireDate, string isAtTheMoneyOption)
        {
            this.sysCode = sysCode;
            this.exchangeId = exchangeId;
            this.productId = productId;
            this.contractId = contractId;
            this.instrumentId = instrumentId;
            this.strikePrice = strikePrice;
            this.optionsType = optionsType;
            this.expireDate = expireDate;
            this.isAtTheMoneyOption = isAtTheMoneyOption;
        }
    }

    public struct BaseData_instrument_securities_extend
    {
        public string sysCode;
        public string preClosePrice;
        public string isCrdBuyUnderlying;
        public string isCrdSellUnderlying;

        public BaseData_instrument_securities_extend(string sysCode, string preClosePrice, string isCrdBuyUnderlying, string isCrdSellUnderlying)
        {
            this.sysCode = sysCode;
            this.preClosePrice = preClosePrice;
            this.isCrdBuyUnderlying = isCrdBuyUnderlying;
            this.isCrdSellUnderlying = isCrdSellUnderlying;
        }
    }

    public struct BaseData_instrument_extend
    {
        public string sysCode;
        public string exchangeId;
        public string productId;
        public string isMainInstrument;
        public string isSubMainInstrument;
        public string avgOpenInterest;
        public string preSettlementPrice;
        public string preClosePrice;
        public string isNearDelivery;
        public string isOptionsUnderlyingInstr;
        public string isOptionsMainUnderlyingInstr;
        public string preOpenInterest;

        public BaseData_instrument_extend(string sysCode, string exchangeId, string productId, string isMainInstrument,
    string isSubMainInstrument, string avgOpenInterest, string preSettlementPrice, string preClosePrice,
    string isNearDelivery, string isOptionsUnderlyingInstr, string isOptionsMainUnderlyingInstr, string preOpenInterest)
        {
            this.sysCode = sysCode;
            this.exchangeId = exchangeId;
            this.productId = productId;
            this.isMainInstrument = isMainInstrument;
            this.isSubMainInstrument = isSubMainInstrument;
            this.avgOpenInterest = avgOpenInterest;
            this.preSettlementPrice = preSettlementPrice;
            this.preClosePrice = preClosePrice;
            this.isNearDelivery = isNearDelivery;
            this.isOptionsUnderlyingInstr = isOptionsUnderlyingInstr;
            this.isOptionsMainUnderlyingInstr = isOptionsMainUnderlyingInstr;
            this.preOpenInterest = preOpenInterest;
        }
    }

    public struct BaseData_instrument_futures_main
    {
        public string sysCode;
        public string exchangeId;
        public string productId;
        public string instrumentId;
        public string instrumentName;
        public string instrumentAbbr;

        public BaseData_instrument_futures_main(string sysCode, string exchangeId, string productId, string instrumentId,
            string instrumentName, string instrumentAbbr)
        {
            this.sysCode = sysCode;
            this.exchangeId = exchangeId;
            this.productId = productId;
            this.instrumentId = instrumentId;
            this.instrumentName = instrumentName;
            this.instrumentAbbr = instrumentAbbr;
        }
    }

    public class BaseData
    {
        public List<BaseData_tradingday> t_tradingday;
        public List<BaseData_product> t_product;
        public List<BaseData_instrument> t_instrument;
        public List<BaseData_etf_options> t_etf_options;
        public List<BaseData_futures_options> t_futures_options;
        public List<BaseData_instrument_securities_extend> t_instrument_securities_extend;
        public List<BaseData_instrument_extend> t_instrument_extend;
        public List<BaseData_instrument_futures_main> t_instrument_futures_main;
        public BaseData()
        {
            t_tradingday = null;
            t_product = null;
            t_instrument = null;
            t_etf_options = null;
            t_futures_options = null;
            t_instrument_securities_extend = null;
            t_instrument_extend = null;
            t_instrument_futures_main = null;
        }
    }
    /// <summary>
    /// ////////////////////内部使用////////////////////////////////
    /// </summary>
    public class TradingTimeFrame
    {
        public string StartTime;    //格式: 09:30
        public string EndTime;

        public TradingTimeFrame(string s, string e)
        {
            StartTime = s;
            EndTime = e;
        }

        bool IsValid()
        {
            return GCommon.IsStandardTimeHHMM(StartTime) && GCommon.IsStandardTimeHHMM(EndTime);
        }
    }

    public class TradingDay
    {
        public int Year;
        public int Month;
        public int Day;
        public TradingDay()
        {
            Year = DateTime.Now.Year;
            Month = DateTime.Now.Month;
            Day = DateTime.Now.Day;
        }
        public TradingDay(int i)
        {
            Year = DateTime.Now.AddDays(i).Year;
            Month = DateTime.Now.AddDays(i).Month;
            Day = DateTime.Now.AddDays(i).Day;
        }

        public static bool IsTradingDay(string str)  //20190617
        {
            return (str.Length == 8) && GCommon.IsNumeric(str);
        }

        public void Set(string str)
        {
            if (!IsTradingDay(str))
                return;
            try
            {
                Year = int.Parse(str.Substring(0, 4));
                Month = int.Parse(str.Substring(4, 2));
                Day = int.Parse(str.Substring(6, 2));
            }
            catch(Exception)
            {
                GCommon.LOG("!!TradingDay set Error" + str);
            }
        }

        public int Combine()
        {
            return Year * 10000 + Month * 100 + Day;
        }
    }

    public class AllTradingDays
    {
        public TradingDay tradingday;
        public TradingDay preTradingday;
        public TradingDay preTradingdayNextDay;

        public AllTradingDays()
        {
            tradingday = new TradingDay();
            preTradingday = new TradingDay(-1);
            preTradingdayNextDay = new TradingDay();
        }
    }

    public class ExternalExchange
    {
        public const string SH= ".SH";
        public const string SZ = ".SZ";
    }

    public class InternalExchange
    {
        public const string SSE = "SSE";
        public const string SZSE = "SZSE";
        public const string SHFE = "SHFE";
        public const string DCE = "DCE";
        public const string CZCE = "CZCE";
        public const string CFFEX = "CFFEX";
        public const string INE = "INE";
        public const string SGE = "SGE";
    }

    public class NewsData
    {
        public string newsId;
        public string title;
        public string time;
        public string sysCode;
        public string type;
        public string url;
        public string shareCode;
        public int size;

        public NewsData()
        {
            newsId = "";
            title = "";
            time = "";
            sysCode = "";
            type = "";
            url = "";
            shareCode = "";
            size = 0;
        }

        public NewsData(string _newsId, string _title, string _time, string _sysCode, string _type, string _url, string _shareCode, int _size)
        {
            newsId = _newsId;
            title = _title;
            time = _time;
            sysCode = _sysCode;
            type = _type;
            url = _url;
            shareCode = _shareCode;
            size = _size;
        }
    }

    public class NoticeData
    {
        public string newsId;
        public string title;
        public string time;
        public string sysCode;
        public string type;
        public string url;
        public string shareCode;
        public int size;

        public NoticeData()
        {
            newsId = "";
            title = "";
            time = "";
            sysCode = "";
            type = "";
            url = "";
            shareCode = "";
            size = 0;
        }

        public NoticeData(string _newsId, string _title, string _time, string _sysCode, string _type, string _url, string _shareCode, int _size)
        {
            newsId = _newsId;
            title = _title;
            time = _time;
            sysCode = _sysCode;
            type = _type;
            url = _url;
            shareCode = _shareCode;
            size = _size;
        }
    }

    public enum eSysType
    {
        eStock = 1,
        eCtp,
        eCredit,
    }

    //优先显示现货还是两融
    public enum eSysPriorityShow
    {
        eNone = 1,
        eStock,
        eCredit,
    }

    public struct stInstrument
    {
        public string syscode;
        public string name;
    }
}
